import axiosInstance from '@/configs/service';
import { PaginationResponse, Role, RolesQuery } from '@/types';

export const getRoleListByPagination = (query: RolesQuery) => {
    return axiosInstance.get<PaginationResponse<Role>>('/staff/role', {
        params: query,
    });
};

export const getSingleRole = (roleId: string) => {
    return axiosInstance.get<Role>(`/staff/role/${roleId}`);
};

export const createRole = (body: Role) => {
    return axiosInstance.post<Role>('/staff/role', body);
};

export const updateRole = (roleId: string, body: Role) => {
    return axiosInstance.put<Role>(`/staff/role/${roleId}`, body);
};

export const deleteRole = (roleId: string) => {
    return axiosInstance.delete<Role>(`/staff/role/${roleId}`);
};

export const restoreRole = (roleId: string) => {
    return axiosInstance.put<Role>(`/staff/role`, {
        roleId,
    });
};
