import axiosInstance from '@/configs/service';
import { MedicalCertificate, PaginationParams, PaginationResponse } from '@/types';

export const getMedicalCertificationList = (query: PaginationParams) => {
    return axiosInstance.get<PaginationResponse<MedicalCertificate>>(`/staff/medical-certificate`, { params: query });
};

export const approveMedicalCertificate = (id: string) => {
    return axiosInstance.put(`/staff/medical-certificate/${id}/approve`);
};

export const rejectMedicalCertificate = (id: string, reason: string) => {
    return axiosInstance.put(`/staff/medical-certificate/${id}/reject`);
};
