import axiosInstance from '@/configs/service';
import { Member, Role } from '@/types';

export const getRoleData = () => {
    return axiosInstance.get<Role[]>('/staff/data/role');
};

export const getMemberData = (keyword: String) => {
    return axiosInstance.get<Pick<Member, 'id' | 'fullName'>[]>('/staff/data/member', { params: { keyword } });
};

export const getAllStudyRequest = () => {
    return axiosInstance.get('/staff/data/request-list');
};

export const getAllMedicalCertificate = () => {
    return axiosInstance.get('/staff/data/medical-certificate-list');
};

export const getBookTokenRequestCount = () => {
    return axiosInstance.get('/staff/data/book-token-request-count');
};
