import axiosInstance from '@/configs/service';
import { PaginationResponse } from '@/types';
import { StudyRequest } from '@/types/book-request';
import { StudyGroup } from '@/types/study-group';

export const getAllStudyRequestList = (query: StudyRequest) => {
    return axiosInstance.get<PaginationResponse<StudyRequest>>('/staff/study-request/all', { params: query });
};

export const getStudyRequestList = (bookId: string, query: StudyRequest) => {
    return axiosInstance.get<PaginationResponse<StudyRequest>>(`/staff/study-request/${bookId}/single`, { params: query });
};

export const getStudyGroupListByBookId = (bookId: string) => {
    return axiosInstance.get(`/staff/study-request/${bookId}/study-group`);
};

export const deleteStudyRequest = (memberId: string, requestId: string) => {
    return axiosInstance.delete<StudyRequest>(`/staff/study-request/${memberId}/${requestId}/delete`);
};

export const rejectStudyRequest = (memberId: string, requestId: string, reason: string) => {
    return axiosInstance.delete<StudyRequest>(`/staff/study-request/${memberId}/${requestId}/reject`, { data: { reason } });
};

export const approveStudyRequest = (bookId: string, memberId: string, body: StudyGroup) => {
    return axiosInstance.put<StudyRequest>(`/staff/study-request/${bookId}/${memberId}/approve`, body);
};
