import { useState } from 'react';

const useModal = (defaultState: boolean = false) => {
    const [open, setOpen] = useState<boolean>(defaultState);

    const toggle = () => setOpen(!open);

    return [open, setOpen, toggle] as const;
};

export default useModal;
