import { Dispatch, SetStateAction } from 'react';
import { Modal } from 'antd';

interface PreviewImageProps {
    open: boolean;
    setOpen: Dispatch<SetStateAction<boolean>>;
    title: string;
    src: string;
}

const PreviewImage: React.FC<PreviewImageProps> = ({ open, setOpen, title, src }) => {
    return (
        <Modal
            open={open}
            title={title}
            footer={null}
            onCancel={() => {
                setOpen(false);
            }}
        >
            <img alt="example" style={{ width: '100%' }} src={src} />
        </Modal>
    );
};

export default PreviewImage;
