import { IncomingMessage } from "http";
import { MEMBER_TOKEN_COOKIE_NAME } from "@/configs";
import { authenticationMember } from "@/services/auth";

export const authentication = async (
    req: IncomingMessage & {
        cookies: Partial<{
            [key: string]: string;
        }>;
    },
) => {
    const token = req.cookies[MEMBER_TOKEN_COOKIE_NAME];

    if (!token) {
        throw new Error("token not found");
    }

    const response = await authenticationMember({
        token: token ? token : "",
    });

    const result = response.data;

    return result;
};
