import { Book, Member, PaginationState } from '.';
import { Staff } from './staff';

export enum StudyGroupStatus {
    DRAFT = 'DRAFT',
    GENERATED = 'GENERATED',
    ONGOING = 'ONGOING',
    COMPLETED = 'COMPLETED',
}

export enum MedicalCertificateStatus {
    PENDING = 'PENDING',
    APPROVED = 'APPROVED',
    REJECTED = 'REJECTED',
}

export interface StudyGroup extends PaginationState {
    id: string;
    bookId: string;
    name: string;
    status: StudyGroupStatus;
    startDate: string;
    endDate: string;
    description: string;
    createdAt: string;
    updatedAt: string;
    book: Book;
    studyGroupTask: StudyGroupTask[];
    studyGroupMembers: StudyGroupMember[];
    _count: {
        studyGroupMembers: number;
    };
}

// Study Group Member
export interface StudyGroupMember {
    id?: string;
    memberId: string;
    studyGroupId: string;
    createdAt: string;
    updatedAt: string;
    studyGroup: StudyGroup;
    member: Member;
    memberCount: number;
    studyGroupMembers: MemberData[];
}

export interface MemberData {
    id: string;
    fullName: string;
    createdAt: string;
    phoneNumber: string;
}

// Study Group Task
export interface StudyGroupTask {
    id: string;
    studyGroupId: string;
    description: string;
    taskDate: string;
    status: boolean;
    createdAt: string;
    updatedAt: string;
    studyGroup: StudyGroup;
    studyGroupTaskComment: StudyGroupTaskComment[];
    penalties: Penalty[];
}

export interface StudyGroupTaskComment {
    id: string;
    studyGroupTaskId: string;
    memberId: string;
    staffId: string;
    comment: string;
    prePlanned: boolean;
    prePlannedDate: string;
    commentDate: string;
    likeCount: number;
    parent_id: string;
    Children: StudyGroupTaskComment[];
    createdAt: string;
    updatedAt: string;
    studyGroupTask: StudyGroupTask;
    member: Member;
    staff: Member;
    replies: Replies[];
}

export interface Replies {
    id: string;
    studyGroupTaskId: string;
    memberId: string;
    staffId: string;
    comment: string;
    prePlanned: boolean;
    prePlannedDate: string;
    commentDate: string;
    likeCount: number;
    parent_id: string;
    Children: Replies[];
    createdAt: string;
    updatedAt: string;
    studyGroupTask: StudyGroupTask;
    member: Member;
    staff: Staff;
}

export interface StudyGroupMemberTaskComment {
    id: string;
    comment: string;
    createdAt: string;
    studyGroupTask: StudyGroupTask;
    member: Member;
}

export interface CommentLike {
    id: string;
    studyGroupTaskId: string;
    studyGroupTaskCommentId: string;
    memberId: string;
}

// Penalty
export interface Penalty {
    id: string;
    memberId: string;
    studyGroupTaskId: string;
    amount: number;
    createdAt: string;
    updatedAt: string;
    member: Member;
    studyGroupTask: StudyGroupTask;
    totalAmount: number;
}

export interface StudyGroupPenaltySummary {
    amount: number;
    member: Member;
}

// Medical Certificate
export interface MedicalCertificate {
    id: string;
    memberId: string;
    studyGroupTaskId: string;
    status: MedicalCertificateStatus;
    applyDate: string;
    createdAt: string;
    updatedAt: string;
}

export type UploadMedicalCertificatePayload = {
    medias: { mediaId: string }[];
};
