import { PaginationParams, TokenType } from '.';

export enum MemberStatus {
    ACTIVE = 'ACTIVE',
    INACTIVE = 'INACTIVE',
}

interface MemberToken {
    memberId: string;
    type: TokenType;
    token: string;
    expiredAt: string;
    createdAt: string;
    updatedAt: string;
    usedAt?: string;
}

export interface Member {
    id: string;
    fullName: string;
    preferredName: string;
    phoneNumber: string;
    address: string;
    email: string;
    dateOfBirth: string;
    password: string;
    country: string;
    state: string;
    city: string;
    isPaid: boolean;
    status: MemberStatus;
    tokens: MemberToken[];
    bookTokens: number;
    lastActive: string;
    createdAt: string;
    updatedAt: string;
}

export interface MemberQuery extends PaginationParams {
    fullNameEmail?: string;
}

export interface UpdateMemberProfileParams {
    fullName: string;
    preferredName: string;
    address: string;
    dateOfBirth: string;
    country: string;
    state: string;
    city: string;
}

export interface UpdateMemberEmailParams {
    email: string;
}

export interface UpdateMemberPhoneNumberParams {
    phoneNumber: string;
}

export interface UpdateMemberPasswordParams {
    password: string;
}
