import { Book, BookTokenSubscriptionStatus, Member } from '.';
import { BookOrderStatus } from './book-order';
import { Package } from './package';

export interface InvoiceBase {
    displayId: string;
    updatedAt: string;
    createdAt: string;
    price: number;
    numberOfBookTokens: number;
    quantity: number;
    paymentStatus: BookTokenSubscriptionStatus;
    member: Member;
    package: Package;
}

export interface BookInvoice {
    id: string;
    displayId: string;
    quantity: number;
    bookPrice: number;
    createdAt: string;
    updatedAt: string;
    status: BookOrderStatus;
    book: Book;
    member: Member;
}
