import exp from 'constants';
import { MediaResponse, PaginationParams } from '.';

export enum UploadType {
    LINK = 'LINK',
    FILE = 'FILE',
}

export enum BookStatus {
    PENDING = 'PENDING',
    JOINED = 'JOINED',
    CANCELLED = 'CANCELLED',
    REJECTED = 'REJECTED',
}

export interface Book {
    id: string;
    name: string;
    link?: string;
    uploadType: UploadType;
    description: string;
    createdAt: string;
    price: number;
    remarks: string;
    availableForBuy: boolean;
    bookMedias: {
        media: MediaResponse;
    }[];
    studyBookRequest: {
        status: BookStatus;
    }[];
    bookImages: {
        media: MediaResponse;
    }[];
}

export interface BookQuery extends PaginationParams {
    name?: string;
    createdAt?: string;
}

export interface StudyBookRequest {
    id: string;
    memberId: string;
    bookId: string;
    status: BookStatus;
    reason?: string;
    createdAt: string;
    book: Book;
}

export interface BookTokenPrice {
    bookTokenPrice: number;
}
