import * as Joi from 'joi';
import { passwordRegex } from 'src/utils/regex';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const staffQuerySchema = Joi.object({
    fullNameEmail: Joi.string().trim().lowercase().allow(null, ''),
    role: Joi.string().allow(null, ''),
}).concat(paginationSchema);

export const createStaffSchema = Joi.object({
    fullName: Joi.string().required(),
    email: Joi.string().trim().lowercase().required(),
    roleId: Joi.string().required(),
    phoneNumber: Joi.string().required(),
});

export const staffEmailSchema = Joi.object({
    email: Joi.string().trim().lowercase().required(),
});

export const updateStaffRoleSchema = Joi.object({
    roleId: Joi.string().required(),
});

export const updateStaffProfileSchema = Joi.object({
    fullName: Joi.string().required(),
});

export const updateStaffEmailSchema = Joi.object({
    email: Joi.string().email().required(),
});

export const updateStaffPhoneNumberSchema = Joi.object({
    phoneNumber: Joi.string().required(),
});

export const updateStaffPasswordSchema = Joi.object({
    password: Joi.string().regex(passwordRegex, 'password').required(),
});
