import { Injectable } from '@nestjs/common';
import { StudyBookRequestStatus } from '@prisma/client';
import { PrismaService } from 'src/prisma/prisma.service';
import * as dayjs from 'dayjs';

@Injectable()
export class StaffDashboardService {
    constructor(private prisma: PrismaService) {}

    async getDashboardStatistics() {
        /* Get number of members */
        const numberOfMembers = await this.prisma.member.count({
            where: {
                deletedAt: null,
            },
        });

        /* Get Number of Study Request */
        const numberOfStudyRequest = await this.prisma.studyBookRequest.count({
            where: {
                deletedAt: null,
                status: StudyBookRequestStatus.PENDING,
            },
        });

        /* Get number of penalties this week */
        const currentStartWeek = dayjs().startOf('week');
        const currentEndWeek = dayjs().endOf('week');
        const numberOfPenaltiesThisWeek = await this.prisma.penalty.count({
            where: {
                deletedAt: null,
                createdAt: {
                    gte: currentStartWeek.toDate(),
                    lte: currentEndWeek.toDate(),
                },
            },
        });

        const body = {
            numberOfMembers,
            numberOfStudyRequest,
            numberOfPenaltiesThisWeek,
        };

        return body;
    }
}
