import * as Joi from 'joi';
import { paginationSchema } from 'src/utils/validators/pagination.schema';

export const studyGroupQuerySchema = Joi.object({
    name: Joi.string().allow(null, ''),
    bookName: Joi.string().allow(null, ''),
    status: Joi.string().allow(null, ''),
    startDate: Joi.string().allow(null, ''),
    endDate: Joi.string().allow(null, ''),
    createdAt: Joi.array().items(Joi.string().required()).allow(null, ''),
}).concat(paginationSchema);

export const studyGroupByIdSchema = Joi.object({
    studyGroupId: Joi.string().required(),
});

export const studyGroupTaskByIdSchema = Joi.object({
    studyGroupTaskId: Joi.string().required(),
});

export const studyGroupSubTaskByIdSchema = Joi.object({
    studyGroupSubTaskId: Joi.string().required(),
});

export const studyGroupMemberCommentSchema = Joi.object({
    name: Joi.string().allow(null, ''),
    bookName: Joi.string().allow(null, ''),
    status: Joi.string().allow(null, ''),
    startDate: Joi.string().allow(null, ''),
    endDate: Joi.string().allow(null, ''),
    createdAt: Joi.array().items(Joi.string().required()).allow(null, ''),
});

export const updateCommentSchema = Joi.object({
    comment: Joi.string().allow(null, ''),
    reply: Joi.string().allow(null, ''),
    commentId: Joi.string().allow(null, ''),
});

export const updateReplySchema = Joi.object({
    reply: Joi.string().allow(null, ''),
    commentId: Joi.string().allow(null, ''),
});

export const scheduleCommentSchema = Joi.object({
    comment: Joi.string().allow(null, ''),
    prePlannedDate: Joi.string().allow(null, ''),
});

export const uploadMedicalCertificateSchema = Joi.object({
    medias: Joi.array()
        .items(Joi.object({ mediaId: Joi.string().required() }).required())
        .required(),
});

export const studyGroupTaskCommentSchema = Joi.object({
    studyGroupTaskCommentId: Joi.string().allow(null, ''),
});
