import { NestFactory } from '@nestjs/core';
import { AppModule } from './app.module';
import { NestExpressApplication } from '@nestjs/platform-express';
import { ConfigService } from '@nestjs/config';
import * as colors from 'colors';
import * as cookieParser from 'cookie-parser';
import * as morgan from 'morgan';
import helmet from 'helmet';
import * as compression from 'compression';
import { API_URL, MEMBER_URL, STAFF_URL } from './config';
import { morganFormat } from './utils';
import { json, urlencoded } from 'express';

async function bootstrap() {
    const app = await NestFactory.create<NestExpressApplication>(AppModule, {
        logger: ['error', 'warn'],
    });

    const configService = app.get<ConfigService>(ConfigService);
    const port = configService.get<number>('PORT', 4000);
    colors.enable();

    app.use([
        json({ limit: '10mb' }),
        urlencoded({ extended: true, limit: '10mb' }),
        cookieParser(),
        helmet({
            crossOriginResourcePolicy: false,
        }),
        morgan(morganFormat),
        compression(),
    ]);
    app.enableCors({
        origin: [API_URL, STAFF_URL, MEMBER_URL],
        credentials: true,
    });
    app.setGlobalPrefix('api');

    await app.listen(port, () => {
        console.log(`Server is running on port ${port}`.green.bold);
    });
}
bootstrap();
