import { CACHE_MANAGER } from '@nestjs/cache-manager';
import { Inject, Injectable } from '@nestjs/common';
import { Cache } from 'cache-manager';
import { DeleteCacheOptions } from './type';

@Injectable()
export class CacheService {
    constructor(@Inject(CACHE_MANAGER) private readonly cacheManger: Cache) {}

    async get<T = any>(key: string): Promise<T> {
        return this.cacheManger.get(key);
    }

    async set<T = any>(key: string, value: T): Promise<void> {
        await this.cacheManger.set(key, value);
    }

    async delete(key: string, options: DeleteCacheOptions = { exact: false }): Promise<void> {
        const { exact } = options;

        if (exact) {
            await this.cacheManger.del(key);
            return;
        }
        const keys = await this.cacheManger.store.keys();

        const keyToDelete = keys.filter((k) => k.includes(key));

        keyToDelete.forEach(async (k) => {
            await this.cacheManger.del(k);
        });
    }

    async reset(): Promise<void> {
        await this.cacheManger.reset();
    }
}
